% Obtain the least square approximation of the signal
%      x = (0: 0.1: 5)'; 
%      y=erf(x);

clear variables;
close all;

order=6;

x=(0:0.1:5)';
y=erf(x);

% caculate least square approximation
p=polyfit(x,y,order);
% obtain estimated values to compare results
yEst=polyval(p,x);

err=abs(y-yEst);

meanErr=mean(err);

stdErr=std(err);

fprintf('Mean absolute error: %i\n Standard deviation absolute error: %i\n',meanErr,stdErr);

plot(x,y,'LineWidth', 2);
hold on
plot(x,yEst,'r--','LineWidth', 2);
title('Polynomial approximation');
xlabel('x');
ylabel('y');
legend('input signal', 'approximated signal');